package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 更新OMS发货单生成状态参数
 *
 * @author fred
 * @since 2021-05-14 11:32:19
 */

@Data
@ApiModel(value = "SalDoGenReqDTO", description = "更新OMS发货单生成状态参数")
public class SalDoGenReqDTO implements Serializable {

    private static final long serialVersionUID = -8884539682305072717L;
    /**
     * 发货单ID
     */
    @ApiModelProperty("发货单ID")
    @NotNull(message = "发货单ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 生成状态
     */
    @ApiModelProperty("生成状态")
    @NotBlank(message = "生成状态不能为空")
    private String genStatus;

}