package com.elitesland.order.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.order.Application;
import com.elitesland.order.param.StoreCheckPagingParam;
import com.elitesland.order.param.StoreCheckRespDTO;
import com.elitesland.order.param.StoreCheckSaveVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + StoreCheckRpcService.PATH)
@Validated
public interface StoreCheckRpcService {
    String PATH = "/storeCheckRpc";

    /**
     * 门店对照-分页查询
     */
    @PostMapping("/page")
    ApiResult<PagingVO<StoreCheckRespDTO>> page(@RequestBody StoreCheckPagingParam param);

    /**
     * 门店对照-列表查询
     */
    @PostMapping("/list")
    ApiResult<List<StoreCheckRespDTO>> list(@RequestBody StoreCheckPagingParam param);

    /**
     * 门店对照-根据ID查询
     */
    @PostMapping("/getById")
    ApiResult<StoreCheckRespDTO> getById(@RequestParam("id") Long id);

    /**
     * 门店对照-保存
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody StoreCheckSaveVO saveVO);

    /**
     * 门店对照-删除
     */
    @PostMapping("/deleteById")
    ApiResult<Void> deleteById(@RequestParam("id") Long id);
}
