package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jin
 * @since 2021-12-24
 */
@Data
@ApiModel(description = "数据检查跨库专用DTO")
public class CheckInvAndPurRpcDTO implements Serializable {

    @ApiModelProperty("主表id")
    private Long id;
    @ApiModelProperty("单据编号")
    private String docNo;
    @ApiModelProperty("单据状态")
    private String docStatus;
    @ApiModelProperty("单据类型")
    private String docType;
    @ApiModelProperty("发货数量")
    private BigDecimal dodQty;
    @ApiModelProperty("已签收数量(九专用)")
    private BigDecimal confirmQty;
    @ApiModelProperty("已拒收数量(九专用)")
    private BigDecimal rejectQty;
    @ApiModelProperty("单据类别")
    private String docCls;
    @ApiModelProperty("退货类型")
    private String returnType;
    @ApiModelProperty("单据类型2 [UDC]SAL:SO_TYPE2")
    private String docType2;
}
