package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 退货收货单(SalDoDO)保存参数
 *
 * @author dave
 * @since 2021-05-17 11:32:18
 */

@Data
@ApiModel(value = "退货收货单保存参数")
public class SalDoReturnParamDTO implements Serializable {

    private static final long serialVersionUID = -2459112289484392143L;
    /**
     * 主表id
     */
    @ApiModelProperty("主表id")
    private Long id;

    /**
     * 退货订单号
     */
    @ApiModelProperty("退货收货单号")
    private String docNo;

    /**
     * 京云仓单号
     */
    @ApiModelProperty("京云仓单号")
    private String outerNo;

    /**
     * 销售公司id
     */
    @ApiModelProperty("销售公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("退货订单时间")
    private LocalDateTime docTime;


    @ApiModelProperty("收货单日期")
    private LocalDateTime docDate;


    /**
     * 销售公司名称
     */
    @ApiModelProperty("销售公司名称")
    private String ouName;
    /**
     * 销售组织id
     */
    @ApiModelProperty("销售组织id")
    private Long buId;
    /**
     * 销售组织name
     */
    @ApiModelProperty("销售组织name")
    private String buName;

    /**
     * 功能区
     */
    @ApiModelProperty("功能区")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long custId;
    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号")
    private String custCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;
    /**
     * 业务员id
     */
    @ApiModelProperty("业务员id")
    private Long agentEmpId;
    @ApiModelProperty("业务员用户ID")
    private Long agentUserId;

    /**
     * 业务员编号
     */
    @ApiModelProperty("业务员编号")
    private String agentCode;

    /**
     * 业务员名称
     */
    @ApiModelProperty("业务员名称")
    private String agentName;
    /**
     * 销售区域
     */
    @ApiModelProperty("销售区域")
    private String saleRegion;
    /**
     * 销售区域name
     */
    @ApiModelProperty("销售区域name")
    private String saleRegionName;
    /**
     * 客户组
     */
    @ApiModelProperty("客户组")
    private String custGroup;

    /**
     * 退货订单类型 [UDC]SAL:SO_TYPE
     */
    @ApiModelProperty("退货订单类型")
    @SysCode(sys = "yst-order", mod = "SO_TYPE")
    private String docType;
    @ApiModelProperty("退货订单类型 name")
    private String docTypeName;

    /**
     * 订单状态 [UDC]SAL:RSO_STATUS
     */
    @ApiModelProperty("退货订单状态")
    @SysCode(sys = "yst-order", mod = "RSO_STATUS")
    private String docStatus;
    @ApiModelProperty("退货订单状态 name")
    private String docStatusName;

    /**
     * 退货原因码 [UDC]SAL:SO_RETURN_REASON
     */
    @ApiModelProperty("退货原因码 [UDC]SAL:SO_RETURN_REASON")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_REASON")
    private String returnReasonCode;
    @ApiModelProperty("退货原因码 Name")
    private String returnReasonCodeName;


    /**
     * 客户订单号
     */
    @ApiModelProperty("客户订单号")
    private String custSoNo;
    /**
     * 仓库
     */
    @ApiModelProperty("仓库")
    private Long whId;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 收货地址号
     */
    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;
    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省份
     */
    @ApiModelProperty("收货省份")
    private String recvProvince;
    /**
     * 收货省份Name
     */
    @ApiModelProperty("收货省份Name")
    private String recvProvinceName;
    /**
     * 城市
     */
    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;
    @ApiModelProperty("城市名称")
    private String recvCityName;
    /**
     * 区县
     */
    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;
    @ApiModelProperty("区县名称")
    private String recvCountyName;
    /**
     * 街道
     */
    @ApiModelProperty("街道")
    private String recvStreet;

    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;
    /**
     * 收货地址
     */
    @ApiModelProperty("收货地址")
    private String recvAddr;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String recvContactName;

    /**
     * 客户手机
     */
    @ApiModelProperty("客户手机")
    private String recvContactTel;


    /**
     * 退货方式
     */
    @ApiModelProperty("退货方式")
    @SysCode(sys = "yst-order", mod = "SO_RETURN_TYPE")
    private String returnType;
    @ApiModelProperty("退货方式 name")
    private String returnTypeName;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("RSO关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("RSO关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("RSO关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("RSO关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("RSO关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("RSO关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("SO关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("SO关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("SO关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("SO关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("SO关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("SO关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    /**
     * 关联单据3类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("SO关联单据3类别 [UDC]COM:DOC_CLS")
    private String relateDoc3Cls;
    /**
     * 关联单据3类型
     */
    @ApiModelProperty("SO关联单据3类型")
    private String relateDoc3Type;
    /**
     * 关联单据3ID
     */
    @ApiModelProperty("SO关联单据3ID")
    private Long relateDoc3Id;
    /**
     * 关联单据3编号
     */
    @ApiModelProperty("SO关联单据3编号")
    private String relateDoc3No;

    /**
     * 来源单据信息 docId
     */
    @ApiModelProperty("来源单据信息 docId")
    private Long rootDocId;

    /**
     * 来源单据信息 docNo
     */
    @ApiModelProperty("来源单据信息 docNo")
    private String rootDocNo;

    /**
     * 来源单据信息 docCls
     */
    @ApiModelProperty("来源单据信息 docCls")
    private String rootDocCls;

    /**
     * 关联单据
     */
    @ApiModelProperty("SO关联单据")
    private String rootDocType;

    /**
     * 制单人
     */
    @ApiModelProperty("制单人")
    private String creator;

    /**
     * 收货指令
     */
    @ApiModelProperty("收货指令")
    private String deliverInstruct;

    /**
     * 收货指令2
     */
    @ApiModelProperty("收货指令2")
    private String deliverInstruc2;

    /**
     * 承运信息
     */
    @ApiModelProperty("承运信息")
    private String carrier;

    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private String deliverMethod;
    @ApiModelProperty("配送方式 name")
    private String deliverMethodName;


    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("是否一件代发")
    private String suppFlag;

    @ApiModelProperty("退货收货单明细List")
    private List<SalDoItemReturnParamDTO> salDoItemReturnParamList;
    /**
     * 附件code 数组
     */
    @ApiModelProperty("附件code 数组")
    private List<String> fileCodes;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;


    /**
     * 营业厅退货标识 "a"代表营业厅退货  "b"代表其他
     */
    @ApiModelProperty("营业厅退货标识 'a'代表营业厅退货  'b'代表其他")
    private String flag;


    @ApiModelProperty("主客户编号")
    private String preCustCode;

    @ApiModelProperty("主客户名称")
    private String preCustName;

    @ApiModelProperty("客户渠道")
    private String saleChannel;


    @ApiModelProperty("币种编号")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("场景码编码")
    private String sceneCode;

    @ApiModelProperty("场景码编码")
    private String sceneName;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("补单 确认时间")
    private LocalDateTime confirmTime;
}