package com.elitesland.order.param;

import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RetailOrderDSaveVO extends BaseModelVOMedItem implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("外部系统类型 JST聚水潭 JKY吉客云 ...")
    private String externalType;
    @ApiModelProperty("外部系统唯一标识 更新用")
    private String externalId;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("是否赠品")
    private Integer isGift;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty("优惠价格")
    private BigDecimal discountPrice;

    @ApiModelProperty("实售价格")
    private BigDecimal price;

    @ApiModelProperty("商品零售金额")
    private BigDecimal goodsRetailAmt;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("商品成交金额")
    private BigDecimal goodsTransactionAmt;

    @ApiModelProperty("商品未税金额")
    private BigDecimal goodsUntaxedAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;

    @ApiModelProperty("其它费用")
    private BigDecimal otherExpenses;

    @ApiModelProperty("应收金额")
    private BigDecimal arAmt;

    @ApiModelProperty("对账状态")
    private String reconcileStatus;

    @ApiModelProperty("核销数量")
    private BigDecimal verQty;

    @ApiModelProperty("实收金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("买家实付")
    private BigDecimal buyerActualPaymentAmt;

    @ApiModelProperty("平台补贴")
    private BigDecimal platformSubsidyAmt;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustmentAmt;

    @ApiModelProperty("买家实付调整")
    private BigDecimal buyerPaymentAdjustmentAmt;

    @ApiModelProperty("平台补贴调整")
    private BigDecimal platformSubsidyAdjustmentAmt;

    @ApiModelProperty("核销时间")
    private LocalDateTime verTime;

    @ApiModelProperty("核销备注")
    private String verRemark;

    @ApiModelProperty("外部出入库单号")
    private String outerInvNo;

    @ApiModelProperty("出入库数量（基本单位）")
    private BigDecimal outerInvQty;

    @ApiModelProperty("出入库数量日期")
    private LocalDateTime outerInvTime;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("行类型 从SalLinetypeDO 表中取line_type")
    private String lineType;

    @ApiModelProperty("行类型 名称")
    private String lineTypeName;

    @ApiModelProperty("行类型 列表")
    private String lineTypeList;

    @ApiModelProperty("行状态 [UDC]SAL:SO_LINE_STATUS")
    private String lineStatus;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("收方仓库ID")
    private Long recvWhId;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("商品cs编码")
    private String itemCsCode;

    @ApiModelProperty("是否供应商代发")
    private String suppFlag;

    @ApiModelProperty("承运商供应商ID")
    private Long carrierSuppId;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("数量2")
    private BigDecimal qty2;

    @ApiModelProperty("单位2")
    private String uom2;

    @ApiModelProperty("单位换算率")
    private BigDecimal uomRatio;

    @ApiModelProperty("单位换算率2")
    private BigDecimal uomRatio2;

    @ApiModelProperty("包装要求")
    private String packDemand;

    @ApiModelProperty("包装数量")
    private BigDecimal packQty;

    @ApiModelProperty("包装单位")
    private String packUom;

    @ApiModelProperty("单个净重")
    private BigDecimal singleNetWeight;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("单个毛重")
    private BigDecimal singleGrossWeight;

    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("重量单位")
    private String weightUom;

    @ApiModelProperty("重量换算率")
    private BigDecimal weightRatio;

    @ApiModelProperty("单个体积")
    private BigDecimal singleVolume;

    @ApiModelProperty("体积")
    private BigDecimal volume;

    @ApiModelProperty("体积单位")
    private String volumeUom;

    @ApiModelProperty("基准价格")
    private BigDecimal basePrice;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("净价")
    private BigDecimal netPrice;

    @ApiModelProperty("交易净价")
    private BigDecimal transNetPrice;

    @ApiModelProperty("交易价格")
    private BigDecimal transPrice;

    @ApiModelProperty("应付金额")
    private BigDecimal apAmt;

    @ApiModelProperty("已付金额")
    private BigDecimal payedAmt;

    @ApiModelProperty("支付中金额")
    private BigDecimal payingAmt;

    @ApiModelProperty("未付金额")
    private BigDecimal openAmt;

    @ApiModelProperty("退货状态")
    private String returnStatus;

    @ApiModelProperty("关联单据类别")
    private String relateDocCls;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据号")
    private String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;

    @ApiModelProperty("关联单据2类别")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;

    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("来源单据类别")
    private String rootDocCls;

    @ApiModelProperty("来源单据类型")
    private String rootDocType;

    @ApiModelProperty("来源单据ID")
    private Long rootDocId;

    @ApiModelProperty("来源单据明细ID")
    private Long rootDocDid;

    @ApiModelProperty("来源单据行号")
    private Long rootDocLineno;

    @ApiModelProperty("来源单据号")
    private String rootDocNo;
    @ApiModelProperty("明细")
    private List<RetailOrderOdoSaveVO> details;
}