package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class SalSoQueryDTO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -8708302229191695381L;
    @ApiModelProperty("店铺名称")
    private String storeName;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;
    /**
     * 销售订单号
     */
    @ApiModelProperty("销售订单号")
    private String docNo;

    @ApiModelProperty("销售订单号 集合")
    private List<String> docNos;
    /**
     * 收款金额
     */
    @ApiModelProperty(value = "收款金额")
    private BigDecimal receiptAmt;
    /**
     * 平台订单号
     */
    @ApiModelProperty("平台订单号")
    private String docNo2;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("订单创建日期")
    private String createTimeS;
    private String createTimeE;

    @ApiModelProperty("销售订单创建日期")
    private String docTimeS;
    private String docTimeE;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;


    @ApiModelProperty("收货人名称")
    private String custContactName;

    /**
     * 客户联系人电话
     */
    @ApiModelProperty("收货人电话")
    private String custContactTel;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    /**
     * 发货状态
     */
    @ApiModelProperty("发货状态")
    private String logisStatus;
    /**
     * 订单状态(不再依据这个做查询参数)
     */
    @ApiModelProperty("订单状态(不再依据这个做查询参数)")
    private String docStatus;
    /**
     * 订单状态集合（不传查所有状态）
     */
    @ApiModelProperty("订单状态集合（不传查所有状态）")
    private List<String> docStatusList;
    /**
     * 拣货状态
     */
    @ApiModelProperty("拣货状态 [UDC]SAL:SO_PICKING_STATUS")
    private String pickingStatus;
    /**
     * 拣货状态
     */
    @ApiModelProperty("退货状态 [UDC]SAL:SO_RETURN_STATUS")
    private String returnStatus;

}
