package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SalSoItemReturnRespDTO implements Serializable {

    private static final long serialVersionUID = 6745482267835457151L;
    /**
     * 退货商品明细id
     */
    @ApiModelProperty("退货商品明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 退货单主表id
     */
    @ApiModelProperty("退货单主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    /**
     * 退货订单号
     */
    @ApiModelProperty("退货订单号")
    private String docNo;

    /**
     * 订单条目id
     */
    @ApiModelProperty("订单条目id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    /**
     * 订单条目明细id
     */
    @ApiModelProperty("订单条目明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;

    /**
     * 订单条目编号
     */
    @ApiModelProperty("订单条目编号")
    private String relateDocNo;

    /**
     * 发货单条目编号
     */
    @ApiModelProperty("发货单条目编号")
    private String relateDoc2No;

    /**
     * 发货单条目id
     */
    @ApiModelProperty("发货单条目id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;

    /**
     * 发货单条目明细id
     */
    @ApiModelProperty("发货单条目明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 商品品牌
     */
    @ApiModelProperty("商品品牌")
    private String itemBrand;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 1、RSOD(退货订单明细)：申请退货数量->=0。默认=可退数量，能手输，不能大于可退数量（发货10，已退3，则申请退货默认7，不能>7）。
     * 2、RDOD(退货收货单明细)：实收退货数量-默认值DEMAND_QTY，可手改(大于零/小于等于DEMAND_QTY)
     */
    @ApiModelProperty("RSOD申请退货数量/RDOD实收退货数量/退货数量")
    private BigDecimal qty;

    /**
     * 订单数量
     */
    @ApiModelProperty("订单数量")
    private BigDecimal orderQty;

    /**
     * 已发货数量
     */
    @ApiModelProperty("已发货数量")
    private BigDecimal shippedQty;

    /**
     * 退货数量
     */
    @ApiModelProperty("退货数量")
    private BigDecimal returnedQty;

    /**
     * RSOD(退货订单明细)：实限退货数量-默认为0，由退货收货单回写。不能改
     */
    @ApiModelProperty("实际退货数量/已收数量")
    private BigDecimal confirmQty;

    /**
     * RDOD(退货收货单明细)：申请退货数量-RSOD(退货订单明细)的QTY(申请退货数量) - CONFIRM_QTY(实限退货数量)
     */
    @ApiModelProperty("申请退货数量")
    private BigDecimal demandQty;

    /**
     * 待收货数量
     */
    @ApiModelProperty("待收货数量")
    private BigDecimal unonfirmQty;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("是否一件代发")
    private String suppFlag;
}
