package com.elitesland.order.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Shadow
 * @since 2021-07-09 16:21
 */
@Data
public class SalDoDQueryDTO implements Serializable {

    private static final long serialVersionUID = -3851543740059308327L;

    @ApiModelProperty("明细列表")
    private List<Long> ids;//dod

    @ApiModelProperty("发货单编号")
    private String docNo;//do

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户编码")
    private Long custId;

    @ApiModelProperty("发货起始日期")
    private LocalDateTime docTimeStart;

    @ApiModelProperty("发货截止日期")
    private LocalDateTime docTimeEnd;

    @ApiModelProperty("签收起始日期")
    private LocalDateTime confirmTimeStart;

    @ApiModelProperty("签收截止日期")
    private LocalDateTime confirmTimeEnd;

    @ApiModelProperty("发货单状态 [UDC]SAL:DO_STATUS")
    private String docStatus;

    @ApiModelProperty("对账状态")
    private String soaStatus;

    // 验收查询
    @ApiModelProperty("合同ID")
    private Long contractId;

    @ApiModelProperty("合同编码")
    private String contractCode;

    @ApiModelProperty("验收状态")
    private String examStatus;

    @ApiModelProperty("分页页码 默认：0")
    private Integer current;

    @ApiModelProperty("分页大小 默认：10")
    private Integer size;

}
