package com.elitesland.order.param;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "SalSoSaveDTO", description = "销售订单表")
public class SalSoCloseDTO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -1316227664120098172L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    private String closeTime;
    /**
     * 关单原因码 [UDC]SAL:SO_CLOSE_REASON
     */
    @ApiModelProperty("关单原因码 [UDC]SAL:SO_CLOSE_REASON")
    private String closeReasonCode;
    /**
     * 关单人ID
     */
    @ApiModelProperty("关单人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long closeUserId;
}
