package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(description = "门店对照分页查询参数")
public class StoreCheckPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("店铺编码")
    private String storeCode;

    @ApiModelProperty("店铺名称")
    private String storeName;

    @ApiModelProperty("来源渠道")
    private String sourceChannel;

    @ApiModelProperty("经营性质")
    private String businessType;

    @ApiModelProperty("渠道类型")
    private String channelType;

    @ApiModelProperty("是否一件代发：0-否 1-是")
    private Boolean onePieceSend;

    @ApiModelProperty("店长姓名")
    private String managerName;

    @ApiModelProperty("门店电话")
    private String storePhone;
}
