package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 一件代发-批量发货参数-基本信息
 *
 * @author fred
 * @since 2021-05-14 11:32:19
 */

@Data
@ApiModel(value = "SalDoShipReqDTO", description = "一件代发-批量发货参数-基本信息")
public class SalDoShipReqDTO implements Serializable {


    private static final long serialVersionUID = -5900213401179073029L;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 商品明细集合
     */
    @ApiModelProperty("商品明细集合")
    private List<SalDoShipDetailReqDTO> salDoShipDetailReqDTOList;



}