package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 销售发货和退货入库-修改物流
 *
 * @author fred
 * @since 2021-08-30 15:32:17
 */

@Data
@ApiModel(value = "SalDoUpdateLogisDTO", description = "销售发货和退货入库-修改物流")
public class SalDoUpdateLogisDTO implements Serializable {
    private static final long serialVersionUID = -4322349890254819583L;
    /**
     * 发货单id集合
     */
    @ApiModelProperty("发货单id集合")
    private List<Long> idList;
    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private String deliverMethod;
    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;
    /**
     * 物流公司编号
     */
    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;
    /**
     * 物流配送人
     */
    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;
}