package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class SalDeliveryDTO implements Serializable {

    private static final long serialVersionUID = -8542730826203993116L;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("销售订单编码")
    private String orderNo;

    @ApiModelProperty("交货清单")
    @SysCode(sys = "yst-sale", mod = "DELIVERY_LIST")
    private String deliveryNote;
    private String deliveryNoteName;

    @ApiModelProperty("使用要求")
    @SysCode(sys = "yst-sale", mod = "USAGE_REQUIREMENTS")
    private String useDemand;
    private String useDemandName;

    @ApiModelProperty("备注")
    private String remark;
}
