package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 非一件代发-批量发货参数-明细
 *
 * @author fred
 * @since 2021-08-13 11:32:19
 */

@Data
@ApiModel(value = "SalDoShipADetailReqDTO", description = "非一件代发-批量发货参数-明细")
public class SalDoShipADetailReqDTO implements Serializable {


    private static final long serialVersionUID = 4942116828428893232L;
    /**
     * ID
     */
    @ApiModelProperty("ID")
    private Long id;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 要求发货数量-新建时的默认值是可发货数量， 可手填，不能大于可发货数量，不能<=0，保存后，再打开编辑时就带出上次保存的值，可手改。
     */
    @ApiModelProperty("要求发货数量")
    private BigDecimal demandQty;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long logisCarrierId;
    /**
     * 物流公司编号
     */
    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;
    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;
    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;

    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 物流配送人
     */
    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

}