package com.elitesland.order.param;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Shadow
 * @date 2021/06/24 9:55
 */
@Data
@ApiModel(value = "SalSoDUpdateDTO", description = "更新销售订单明细表")
public class SalSoDUpdateDTO implements Serializable {
    private static final long serialVersionUID = 1718797328796928709L;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sodId;

    @ApiModelProperty("开票中金额")
    private BigDecimal invingAmt;

    @ApiModelProperty("待开票金额")
    private BigDecimal noinvAmt;

    @ApiModelProperty("开票中数量")
    private BigDecimal invingQty;

    @ApiModelProperty("待开票数量")
    private BigDecimal noinvQty;

    @ApiModelProperty("已收款金额")
    private BigDecimal payedAmt;

    @ApiModelProperty("收款中金额")
    private BigDecimal payingAmt;

    @ApiModelProperty("应收款余额")
    private BigDecimal openAmt;

    @ApiModelProperty("已开票数量")
    private BigDecimal invedQty;

    @ApiModelProperty("已开票金额")
    private BigDecimal invedAmt;

    @ApiModelProperty("待付款金额")
    private BigDecimal apAmt;

    @ApiModelProperty("开票状态")
    private String invStatus;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

}
