package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * 销售发货和退货入库(SalDo)查询条件
 *
 * @author Unicorn
 * @since 2024-05-09 11:32:18
 */

@Data
@ApiModel(value = "SalDoQueryReqDTO", description = "销售发货和退货入库(SalDo)查询条件")
public class SalDoQueryReqDTO implements Serializable {
    private static final long serialVersionUID = 8194641902354994966L;

    /**
     * 根据单号批量查询，包含
     */
    private List<String> inDocNoList;

    /**
     * 根据单号批量查询，排除
     */
    private List<String> notInDocNoList;

    /**
     * 根据id批量查询，包含
     */
    private List<Long> inIds;

    /**
     * 根据id批量查询，排除
     */
    private List<Long> notInIds;

    /**
     * 根据单据状态，包含
     */
    private List<String> inDocStatus;

    /**
     * 根据单据状态，排除
     */
    private List<String> notInDocStatus;

    /**
     * 根据单据类型，包含
     */
    private List<String> inDocType;

    /**
     * 根据单据类型，排除
     */
    private List<String> notInDocType;
}
