package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "SalDoLogisQueryDTO", description = "协同数据查询-物流")
public class SalDoLogisQueryDTO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -7372477844024544113L;

    /**查询条件：
     * 快递单号、
     * 收货人、
     * 收货人手机、
     * 平台单据号
     * （销售订单号）、
     * 单据创建日期
     */
    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String docNo;
    /**
     * 订单创建开始
     */
    @ApiModelProperty("订单创建开始")
    private String docDateStart;
    /**
     * 订单创建结束
     */
    @ApiModelProperty("订单创建结束")
    private String docDateEnd;

    /**
     * 收货联系人
     */
    @ApiModelProperty("收货联系人")
    private String recvContactName;
    /**
     * 收货联系电话
     */
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;


    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;

}
