package com.elitesland.order.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "SalDoQueryDTO", description = "协同数据查询")
public class SalDoQueryDTO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -3655730194655339418L;

    /**查询条件：
     * 订单编号
     * 平台单据编号
     * 商品名称
     * 店铺
     * 订单创建日期
     * 商品编号
     * 收货人
     * 商品品牌
     * 收货人手机
     * 物流单号
     * 物流公司
     */
    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String docNo;

    /**
     * 平台单据编号
     */
    @ApiModelProperty("平台单据编号")
    private String docNo2;
    /**
     * 销售组织id
     */
    @ApiModelProperty("销售组织id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 销售组织name
     */
    @ApiModelProperty("销售组织name")
    private String buName;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 订单创建日期开始
     */
    @ApiModelProperty("订单创建日期开始")
    private String createTimeS;
    /**
     * 订单创建日期结束
     */
    @ApiModelProperty("订单创建日期结束")
    private String createTimeE;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;

    /**
     * 收货人
     */
    @ApiModelProperty("收货人")
    private String custContactName;

    /**
     * 收货人电话
     */
    @ApiModelProperty("收货人电话")
    private String custContactTel;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;

    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;

    /**
     * 物流公司名称
     */
    @ApiModelProperty("物流公司名称或编号")
    private String logisCarrierMsg;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

}
