package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author evin.dong
 * @date 2021-06-16
 */
@ApiModel(description = "订单收款明细保存参数对象")
@Data
public class SalSoPriceSaveDTO implements Serializable {


    private static final long serialVersionUID = 1302361084821561052L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 销售订单ID
     */
    @ApiModelProperty(value = "销售订单ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soId;
    /**
     * 销售订单明细ID
     */
    @ApiModelProperty(value = "销售订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;
    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private BigDecimal sortNo;
    /**
     * 行类型
     */
    @ApiModelProperty(value = "行类型")
    private String lineType;
    /**
     * 引用ID
     */
    @ApiModelProperty(value = "引用ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long referId;
    /**
     * 折扣ID
     */
    @ApiModelProperty(value = "折扣ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long discId;
    /**
     * 折扣类型
     */
    @ApiModelProperty(value = "折扣类型")
    private String discType;
    /**
     * 折扣编号
     */
    @ApiModelProperty(value = "折扣编号")
    private String discNo;
    /**
     * 折扣描述
     */
    @ApiModelProperty(value = "折扣描述")
    private String discDesc;
    /**
     * 折扣商品ID
     */
    @ApiModelProperty(value = "折扣商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long discItemId;
    /**
     * 折扣数量
     */
    @ApiModelProperty(value = "折扣数量")
    private BigDecimal discQty;
    /**
     * 折扣单价
     */
    @ApiModelProperty(value = "折扣单价")
    private BigDecimal discPrice;
    /**
     * 折扣金额
     */
    @ApiModelProperty(value = "折扣金额")
    private BigDecimal discAmt;
    /**
     * 基于价格
     */
    @ApiModelProperty(value = "基于价格")
    private BigDecimal inPrice;
    /**
     * 价格变化值
     */
    @ApiModelProperty(value = "价格变化值")
    private BigDecimal priceDeltaVal;
    /**
     * 价格变化比例
     */
    @ApiModelProperty(value = "价格变化比例")
    private BigDecimal priceDeltaPercent;
    /**
     * 结果价格
     */
    @ApiModelProperty(value = "结果价格")
    private BigDecimal outPrice;
    /**
     * 刷新时间
     */
    @ApiModelProperty(value = "刷新时间")
    private LocalDateTime refreshTime;
    /**
     * 促销活动ID
     */
    @ApiModelProperty(value = "促销活动ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long promId;
    /**
     * 促销活动明细ID
     */
    @ApiModelProperty(value = "促销活动明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long promDId;
    /**
     * 促销活动编号
     */
    @ApiModelProperty(value = "促销活动编号")
    private String promNo;
    /**
     * 促销活动名称
     */
    @ApiModelProperty(value = "促销活动名称")
    private String promName;
    /**
     * 创建人ID
     */
    @ApiModelProperty(value = "创建人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String createTime;
}
