package com.elitesland.sale.api.vo.resp.zone;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
@Accessors(chain = true)
@ApiModel(description = "专区明细")
public class ZoneSettingDVO implements Serializable {

    private static final long serialVersionUID = 1058894139984208808L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("专区ID")
    private Long zoneId;

    @ApiModelProperty("所属公司")
    private Long ouId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品规格")
    private String itemAttr;

    @ApiModelProperty("商品条码")
    private String barcode;

    @ApiModelProperty("品牌")
    private String itemBrand;

    @ApiModelProperty("品牌")
    private String itemTitle;

    @ApiModelProperty("货币码")
    private String currCode;

    @ApiModelProperty("商品图片ID")
    private Long mainPicId;

    @ApiModelProperty("商品图片URL")
    private String mainPicUrl;

    @ApiModelProperty("基础价")
    private BigDecimal price;

    @ApiModelProperty("客户价")
    private BigDecimal priceCust;

    @ApiModelProperty("排序")
    private Integer sort;


    @ApiModelProperty("商品状态")
    @SysCode(sys = "yst-sale", mod = "ITEM_STATE")
    private String state;
    private String stateName;

    @ApiModelProperty("商品分类")
    private String categoryName;

    @ApiModelProperty("支撑域商品主表ID")
    private List<SupportItem> supportItems = new ArrayList<>();

}
