package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Convert;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/20 13:44
 */
@Data
@ApiModel(description = "创建账户入参")
public class LmCrmCustAccountParam implements Serializable {
    private static final long serialVersionUID = 8043583108996644853L;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty(value = "经销商类型(一网/二网)")
    private String dealerType;

    @ApiModelProperty("业务类型(整车/配件)")
    private String businessType;

    @ApiModelProperty(value = "是否启用")
    private Boolean enable;

    @ApiModelProperty(value = "是否为子账号")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean subAcFlag;

    @ApiModelProperty(value = "账户手机号")
    private String mobile;

    @ApiModelProperty(value = "昵称")
    private String nickName;

    @ApiModelProperty(value = "角色id")
    private Long roleId;


}
