package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author evin.dong
 * @date 2021-05-24
 */
@ApiModel(description = "客户信息详情")
@Data
public class CrmCustDetailRespVO extends BaseModel implements Serializable {

//    private static final long serialVersionUID = 6255460391318669817L;
//    @ApiModelProperty(value = "客户ID")
//    @JsonSerialize(using = ToStringSerializer.class)
//    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户编码弹窗标识")
    private String custCodePopupName;

    @ApiModelProperty(value = "地址簿Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouName;

    @ApiModelProperty(value = "销售组织id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "客户管理专员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    private String agentEmpName;

    @ApiModelProperty(value = "客户分类 [UDC]CRM:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty(value = "客户状态 [UDC]CRM:CUST_STATUS")
    @SysCode(sys = "yst-sale", mod = "CUST_STATUS")
    private String custStatus;
    private String custStatusName;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模 [UDC]CRM:CUST_SCALE")
    @SysCode(sys = "yst-sale", mod = "CUST_SCALE")
    private String compScale;
    private String compScaleName;


    @ApiModelProperty(value = "客户年营业额 [UDC]CRM:CUST_TURNOVER")
    @SysCode(sys = "yst-sale", mod = "CUST_TURNOVER")
    private String compTurnover;
    private String compTurnoverName;

    @ApiModelProperty(value = "客户归类 [UDC]CRM:CUST_TYPE2")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE2")
    private String custType2;
    private String custType2Name;

    @ApiModelProperty(value = "发票类型 [UDC]CRM:INV_TYPE")
    @SysCode(sys = "yst-sale", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人")
    private String invPicName;

    @ApiModelProperty(value = "联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款")
    private String paymentTerm;

    @ApiModelProperty(value = "父项客户号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;
    private String pidCode;

    @ApiModelProperty(value = "客户地址列表数据")
    private List<CrmCustAddrRespVO> addrList;

    @ApiModelProperty(value = "证照信息列表数据")
    private List<CrmCustQualifyRespVO> qualifyList;

    @ApiModelProperty(value = "客户详情")
    private String custDesc;


    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("是否关联账户")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean isCreatedAccount;


    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("客户账户信息")
    private CustAccountVO custAccountVO;

}
