package com.elitesland.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/06/16:42
 * @Description:购物车vo
 */
@Data
@ApiModel(description = "购物车")
public class BipCartVo implements Serializable {

    private static final long serialVersionUID = 6393088081916542387L;



    @ApiModelProperty(name = "公司名称" ,required = true)
    private String ouName;



    @ApiModelProperty(name = "购物车上商品列表")
    private List<BipCartItemRespVO> itemList;

    @ApiModelProperty(name = "订单总金额" )
    private BigDecimal orderTotalItemAmt=BigDecimal.ZERO;

    @ApiModelProperty(name = "运费总金额" )
    private BigDecimal orderTotalFareAmt=BigDecimal.ZERO;


    @ApiModelProperty(name = "订单折扣优惠金额")
    private BigDecimal orderDiscountFreeAmt=BigDecimal.ZERO;


//    @ApiModelProperty(name = "订单优惠券优惠金额" )
//    private BigDecimal orderCpounAmt=BigDecimal.ZERO;


    @ApiModelProperty(name = "订单最终金额" )
    private BigDecimal orderFinalAmt=BigDecimal.ZERO;

    @ApiModelProperty(name = "优惠券ID" )
    private Long couponId;

    @ApiModelProperty(name = "优惠券金额" )
    private BigDecimal couponAmt=BigDecimal.ZERO;

    @ApiModelProperty(name = "优惠券名称" )
    private String couponName;


    @ApiModelProperty(name = "优惠券列表" )
    private List<BipCouponCustVO> BipCouponCustVOS;

}
