package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.dto.SalesmanInfoDTO;
import com.elitesland.sale.dto.query.SalesmanQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author Danny.Wang
 * @title SalesmanRpcService
 * @Date2023/3/2 9:32
 */
@FeignClient(name = Application.NAME, path = SalesmanRpcService.URI)
public interface SalesmanRpcService {
    String URI = Application.URI_PREFIX + "/salesman";

    /**
     * 根据业务员id 或者 业务员编码查询业务员信息
     * @param salesmanQueryDTO
     * @return
     */
    @PostMapping("/salesman/query")
    ApiResult<SalesmanInfoDTO> querySalesmanInfo(SalesmanQueryDTO salesmanQueryDTO);

}
