package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.dto.SalesmanInfoDTO;
import com.elitesland.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.sale.dto.save.SalesmanUpdateDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author Danny.Wang
 * @title SalesmanRpcService
 * @Date2023/3/2 9:32
 */
@FeignClient(name = Application.NAME, path = SalesmanRpcService.URI)
public interface SalesmanRpcService {
    String URI = Application.URI_PREFIX + "/salesman";

    /**
     * 根据业务员id 或者 业务员编码查询业务员信息
     * @param salesmanQueryDTO
     * @return
     */
    @PostMapping("/salesman/query")
    ApiResult<SalesmanInfoDTO> querySalesmanInfo(@RequestBody SalesmanQueryDTO salesmanQueryDTO);

    /**
     * 更改用户头像文件
     * @param salesmanUpdateDTO
     * @return
     */
    @PostMapping("/salesman/update")
    ApiResult<Object> updateSalesmanInfo(@RequestBody SalesmanUpdateDTO salesmanUpdateDTO);

    /**
     * 第一次查询team需要赋值为0
     * 查询下级信息 team为1 并带入上级业务员id
     * @param id
     * @return
     */
    @GetMapping("/salesmanTeam/{team}/{id}")
    ApiResult<Object> salesmanTeam(@PathVariable("id") Integer team, @PathVariable("id") Long id);
}
