package com.elitesland.sale.api.vo.resp.pro;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 返回参数 - 销售合同收款计划信息
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-09 13:58:06
 */
@ApiModel(description = "销售合同收款计划信息返回参数")
@Data
public class SalContractRecvDetailRespVO implements Serializable {

    private static final long serialVersionUID = 8297536951161577386L;

    @ApiModelProperty("主表ID(合同ID)")
    private Long masId;

    @ApiModelProperty("应收金额")
    private BigDecimal arAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("应收日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate arDate;

    @ApiModelProperty("实际收款日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate realRecvDate;

    @ApiModelProperty("录入人")
    private String inputer;

    @ApiModelProperty("录入日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate inputDate;

    @ApiModelProperty("开票日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate invDate;

}
