package com.elitesland.sale.api.vo.resp.shop.app;

import com.elitesland.sale.api.vo.resp.zone.SupportItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/03
 */
@Data
@ApiModel(description = "商品基础信息")
public class BaseBipItemAppRespVO implements Serializable {
    private static final long serialVersionUID = 5836589287025303674L;

    @ApiModelProperty(value = "商品ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "商品中心的商品ID", position = 2)
    private Long itemId;

    @ApiModelProperty(value = "图片的文件标识", position = 3)
    private String picFileCode;

    @ApiModelProperty(value = "图片的链接，若失败可使用picFileCode直接调用文件服务接口", position = 3)
    private String picUrl;

    @ApiModelProperty(value = "商品标题", position = 4)
    private String title;

    @ApiModelProperty(value = "基础价格", position = 5)
    private BigDecimal price;

    @ApiModelProperty(value = "客户价", position = 6)
    private BigDecimal priceCust;

    @ApiModelProperty("货币码")
    private String currCode;

    @ApiModelProperty("支撑域商品列表")
    private List<SupportItem> supportItems = new ArrayList<>();

    @ApiModelProperty("满赠标识")
    private Boolean giftFlag;

    @ApiModelProperty("满减标识")
    private Boolean offsetFlag;

}
