package com.elitesland.sale.api.vo.resp.salesman;

import com.elitescloud.cloudt.common.base.vo.AreaVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Danny.Wang
 * @title EmployeeDetailInfoRespVO
 * @Date2023/2/28 11:37
 */
@Data
@ApiModel("员工详情信息返回参数")
public class EmployeeDetailInfoRespVO implements Serializable {

    @ApiModelProperty("员工ID")
    private Long id;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("用户账号ID")
    private Long userId;

    @ApiModelProperty("员工编号")
    private String code;

    @ApiModelProperty("入职时间")
    private LocalDateTime joinTime;

    @ApiModelProperty("是否启用")
    private Boolean enabled;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("姓名")
    private String fullName;

    @ApiModelProperty("性别")
    private String gender;
    private String genderName;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("办公电话、手机号")
    private String phone;

    @ApiModelProperty("生日")
    private LocalDate birthDate;

    @ApiModelProperty("身份证号")
    private String idCard;

    @ApiModelProperty("所在地")
    private AreaVO areaVO;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("组织信息")
    private List<SysEmployeeDetailDTO.EmployeeOrg> orgList;

    @Data
    public static class EmployeeOrg implements Serializable {
        private static final long serialVersionUID = -7057452386964797575L;

        @ApiModelProperty("组织ID")
        private Long orgId;

        @ApiModelProperty("组织名称")
        private String orgName;

        @ApiModelProperty("领导的员工编号")
        private String leaderEmployeeCode;

        @ApiModelProperty("领导的员工ID")
        private Long leaderEmployeeId;

        @ApiModelProperty("上级领导ID")
        private Long leaderUserId;

        @ApiModelProperty("上级领导姓名")
        private String leaderUserFullName;
    }

}
