package com.elitesland.sale.api.service;

import com.elitesland.sale.api.vo.resp.com.ComSaleFileComVO;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/5/27 11:43
 */
public interface ComSaleFileInfoService {

    /**
     * 根据证件编号集合获取商品图片
     *
     * @param businessType 业务类型
     * @param qualifyNos 证件编号集合
     * @return 文件列表
     */
    List<ComSaleFileComVO> findFileByQualifyNos(String businessType, List<String> qualifyNos);

    /**
     * 保存附件信息，全删全插数据，但不影响文件
     *
     * @param businessType 业务类型
     * @param qualifyNo 证件编码
     * @param params 文件参数
     */
    void comSaleFileHardSave(String businessType, String qualifyNo, List<ComSaleFileComVO> params);

    /**
     * 保存附件信息，全删全插数据，但不影响文件
     *
     * @param businessType 业务类型
     * @param businessId 业务关联ID
     * @param params 文件参数
     */
    void comSaleFileHardSave(String businessType, Long businessId, List<ComSaleFileComVO> params);

    /**
     * 保存附件信息，不全删全插数据
     *
     * @param businessType 业务类型
     * @param businessId 业务关联ID
     * @param params 文件参数
     */
    void comSaleFileHardSaveNotDelete(String businessType, Long businessId, List<ComSaleFileComVO> params);

    /**
     * 根据业务ID获取关联的文件集合
     *
     * @param businessType 业务类型
     * @param businessId 关联业务ID
     * @return 文件列表
     */
    List<ComSaleFileComVO> findFileByBusinessId(String businessType, Long businessId);

}
