package com.elitesland.sale.api.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-09-09 13:20
 */
@Data
public class BipInvItemDTO {

    /**
     * 商品编号
     */
    private String itemCode;
    /**
     * 商品名称
     */
    private String itemName;
    /**
     * 商品数量
     */
    private Long buyQty;
    /**
     * 允许退货数量
     */
    private Long allowBackNum;
    /**
     * 商品规格
     */
    private String itemSpec;
    /**
     * 单位
     */

    @ApiModelProperty("计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    /**
     * skuId
     */
    private Long skuId;
    /**
     * skuCode
     */
    private String skuCode;
    /**
     * 未税税价格
     */
    private BigDecimal netPrice;
    /**
     * 税率
     */
    private BigDecimal taxRate;
    /**
     * 税率编号
     */
    private String taxRateNo;
    /**
     * 含税价格
     */
    private BigDecimal price;
    /**
     * 最终支付价格
     */
    private BigDecimal payAmt;
    /**
     * 运费
     */
    private BigDecimal fareAmt;

    /**
     * 商品ID
     */
    private Long itemId;
    /**
     * 税额
     */
    private BigDecimal tax;
    /**
     * 最终总价
     */
    private BigDecimal buyAmt;

}
