package com.elitesland.sale.api.vo.resp.salesman;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanInfoDetailRespVO
 * @Date2023/2/21 17:04
 */
@Data
@ApiModel("业务员详情查询返回参数")
public class SalesmanInfoDetailRespVO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;

    @ApiModelProperty("管辖区域")
    private String jurisdiction;

    @ApiModelProperty("管辖区域名称")
    private String jurisdictionName;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty("员工详情信息")
    private EmployeeDetailInfoRespVO employeeDetailInfoRespVO;
    
}
