package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "客户信息查询")
public class CrmCustQueryLmParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 7250943807133433470L;
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "外部系统编码")
    private String outerCode;

    @ApiModelProperty("客户组  UDC，开票客户、地址客户、其他")
    private String custGroup;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "状态")
    private String custStatus;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "业务员")
    private Long agentEmpId;

    @ApiModelProperty(value = "父项客户号 展示cust_code字段对应的值，支持模糊查询")
    private String pid;

    @ApiModelProperty(value = "联系人")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "客户类型")
    List<String> custTypes;

    @ApiModelProperty(value = "是否查询下级")
    private Boolean isSearchPid;


}
