package com.elitesland.sale.api.vo.save.shop;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

import java.io.Serializable;

/**
 * 优惠券(BipCoupon)实体类
 *
 * @author Shadow
 * @since 2021-08-11 09:08:10
 */

@Data
@ApiModel(value = "BipCouponSaveVO", description = "优惠券")
public class BipCouponSaveVO implements Serializable {
    private static final long serialVersionUID = -78439805337405284L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 编码
     */
    @ApiModelProperty("编码")
    private String couponCode;
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String couponName;
    /**
     * 优惠券类型 0满减 1立减
     */
    @ApiModelProperty("优惠券类型 0满减 1立减")
    @SysCode(sys = "yst-sale",mod = "COUPON_TYPE")
    private String type;
    private String typeName;
    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private Long ouId;
    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 优惠券数量
     */
    @ApiModelProperty("优惠券数量")
    private Long totalNum;

    /**
     * 已领取数量
     */
    @ApiModelProperty("已领取数量")
    private Long receiveNum;

    @ApiModelProperty("已使用数量")
    private Long useNum;


    /**
     * 客户等级
     */
    @ApiModelProperty("客户等级")
    @SysCode(sys = "yst-sale", mod = "CUST_GROUP")
    private String custLevel;
    private String custLevelName;
    /**
     * 满减最低金额
     */
    @ApiModelProperty("满减最低金额")
    private BigDecimal limitAmt;
    /**
     * 优惠金额
     */
    @ApiModelProperty("优惠金额")
    private BigDecimal freeAmt;
    /**
     * 优惠券状态
     */
    @ApiModelProperty("优惠券状态")
    @SysCode(sys = "yst-sale",mod = "COUPON_STATUS")
    private String state;
    private String stateName;

    /**
     * 失效提前通知天数
     */
    @ApiModelProperty("失效提前通知天数")
    private Integer notifyDays;
    /**
     * 失效提前通知时间
     */
    @ApiModelProperty("失效提前通知时间")
    private LocalDateTime notifyTime;
    /**
     * 优惠券使用类型，匹配品类  匹配商品
     */
    @ApiModelProperty("优惠券使用类型，匹配品类  匹配商品")
    @SysCode(sys = "yst-sale",mod = "COUPON_USE_TYPE")
    private String matchType;
    private String matchTypeName;

    /**
     * 匹配集合
     */
    @ApiModelProperty("匹配集合")
    private String matchIds;
    /**
     * 说明
     */
    @ApiModelProperty("说明")
    private String detailInfo;
    /**
     * 是否专区显示
     */
    @ApiModelProperty("是否专区显示")
    private String specialAreaShow;
    /**
     * 专区开始时间
     */
    @ApiModelProperty("专区开始时间")
    private LocalDateTime specialAreaStime;
    /**
     * 专区结束时间
     */
    @ApiModelProperty("专区结束时间")
    private LocalDateTime specialAreaEtime;
    /**
     * 是否首页展示
     */
    @ApiModelProperty("是否首页展示")
    private String indexPageShow;
    /**
     * 是否新新人专享券
     */
    @ApiModelProperty("是否新人新人专享券")
    private String newCustShow;
    /**
     * 新人券下发开始时间
     */
    @ApiModelProperty("新人券下发开始时间")
    private LocalDateTime newCustStime;
    /**
     * 新人券下发结束时间
     */
    @ApiModelProperty("新人券下发结束时间")
    private LocalDateTime newCustEtime;
    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validStime;
    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validEtime;

    /**
     * 商品明细
     */
    @ApiModelProperty("商品明细")
    private List<BipItemVO> itemList;

}
