package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "客户账户信息")
public class CustAccountVO extends BaseModel {

    private static final long serialVersionUID = 6957811137966670640L;
//    @ApiModelProperty(value = "id")
//    private Long id;

    @ApiModelProperty(value = "userId")
    private Long userId;

    @ApiModelProperty(value = "客户编号")
    private String custCode;
    @ApiModelProperty(value = "客户登录账号")
    private String userName;

    @ApiModelProperty(value = "昵称名称")
    private String nickName;

    @ApiModelProperty(value = "客户手机号")
    private String mobile;

    @ApiModelProperty(value = "客户登录密码")
    private String pwd;

    @ApiModelProperty(value = "账户余额")
    private BigDecimal balance;

    @ApiModelProperty(value = "是否开通账号")
    private Boolean isOpenAccount;

    @ApiModelProperty(value = "发送到系统域生成用户的时间")
    private LocalDateTime createAccountTime;

    @ApiModelProperty(value = "修改密码时间")
    private LocalDateTime updatePwdTime;

    @ApiModelProperty(value = "是否启用")
    private Boolean enable;

    @ApiModelProperty(value = "角色编码")
    private String roleCode;

    @ApiModelProperty(value = "角色id")
    private Long roleId;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "经销商类型(一网/二网)")
    private String dealerType;

    @ApiModelProperty(value = "经营业务类型(整车/配件)")
    private String businessType;

    @ApiModelProperty(value = "是否为子账号")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean subAcFlag;


}
