package com.elitesland.sale.api.vo.resp.salesman;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanInfoRespVO
 * @Date2023/2/21 17:04
 */
@Data
@ApiModel("业务员查询返回参数")
public class SalesmanInfoRespVO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;

    @ApiModelProperty("管辖区域")
    private String jurisdiction;

    @ApiModelProperty("管辖区域名称")
    private String jurisdictionName;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty(value = "业务员表关联员工code")
    private String relateId;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty(value = "员工信息")
    private EmployeeInfoRespVO employeeInfoRespVO;

    @ApiModelProperty(value = "是否拥有下属")
    private boolean hasUnder = false;


}
