package com.elitesland.sale.api.vo.save;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 业务员任务管理-任务
 */
@Data
@ApiModel(description = "任务")
public class TaskInfoSaveVO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1468374420433070556L;

    @ApiModelProperty("任务编码")
    private String code;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务状态")
    private String state;

    @ApiModelProperty("是否逾期")
    private String delayFlag;

    @ApiModelProperty("任务进度")
    private BigDecimal progress;

    @ApiModelProperty("任务类型")
    private String type;

    @ApiModelProperty("所属公司")
    private String ouCode;

    @ApiModelProperty("紧急程度")
    private String urgencyLevel;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("重复设置")
    private String repeatSet;

    @ApiModelProperty("重复类型（次/天/周/月）")
    private String repeatType;

    @ApiModelProperty("重复间隔")
    private BigDecimal repeatInterval;

    @ApiModelProperty("指定天")
    private String appointDay;

    @ApiModelProperty("重复开始时间")
    private LocalDateTime repeatStartTime;

    @ApiModelProperty("重复结束时间")
    private LocalDateTime repeatEndTime;

    @ApiModelProperty("执行时间")
    private LocalDateTime executTime;

    @ApiModelProperty("活动编码")
    private String promotionCode;

    @ApiModelProperty("活动名称")
    private String promotionName;

    @ApiModelProperty("强制签到")
    private String forceSignFlag;

    @ApiModelProperty("签到范围")
    private BigDecimal signInRange;

    @ApiModelProperty("签退范围")
    private BigDecimal signOutRange;

    @ApiModelProperty("发布人")
    private String publishUser;

    @ApiModelProperty("发布人id")
    private Long publishUserId;

    @ApiModelProperty("发布人code")
    private String publishUserCode;

    @ApiModelProperty("执行模板")
    private String executTemplate;

    @ApiModelProperty("任务描述")
    private String taskDesc;

    @ApiModelProperty("文件信息")
    private String fileInfo;

    @ApiModelProperty("执行模板id")
    private Long executTemplateId;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;

}
