package com.elitesland.sale.service;

import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.sale.dto.param.StoreAccountSaveRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = Application.NAME, path = CrmCustAccountRpcService.URI)
public interface CrmCustAccountRpcService {
    String URI = Application.URI_PREFIX + "/custaccount";

    @GetMapping("/getCustAccountByUserId")
    CustAccountVO getCustAccountByUserId(@RequestParam("userName") Long userId);

    /**
     * 保存或更新门店账号<br>
     * 更新时会更新联系电话及启停状态<br>
     *
     * @param param
     */
    @PostMapping("/saveStoreAccount")
    void saveStoreAccount(@RequestBody StoreAccountSaveRpcParam param);


}
