package com.elitesland.sale.api.service;

import com.elitesland.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.sale.api.vo.save.TaskInfoDtlSaveVO;

import java.util.List;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
public interface TaskInfoDtlService {

    /**
     * 任务明细保存
     *
     * @param saveVOList 入参
     * @return 任务明细ID
     */
    List<Long> saveTaskInfoDtl(List<TaskInfoDtlSaveVO> saveVOList);

    /**
     * 根据任务主表ID删除任务明细
     *
     * @param masId 任务主表ID
     * @return
     */
    void deleteByMasId(Long masId);

    /**
     * 根据任务主表ID查询任务明细
     *
     * @param masId 任务主表ID
     * @return 任务明细
     */
    List<TaskInfoDtlRespVO> selectByMasId(Long masId);

    /**
     * 根据入参查询任务明细
     *
     * @param queryVO 入参
     * @return 任务明细
     */
    List<TaskInfoDtlRespVO> selectByParam(TaskInfoDtlQueryVO queryVO);

}
