package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.sale.api.vo.resp.taskinfo.TaskExecuteRespVO;
import com.elitesland.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.sale.api.vo.save.TaskInfoDtlSaveVO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
public interface TaskInfoDtlService {

    /**
     * 任务明细保存
     *
     * @param saveVOList 入参
     * @return 任务明细ID
     */
    List<Long> saveTaskInfoDtl(List<TaskInfoDtlSaveVO> saveVOList);

    /**
     * 根据任务主表ID删除任务明细
     *
     * @param masId 任务主表ID
     * @return
     */
    void deleteByMasId(Long masId);

    /**
     * 根据任务主表ID查询任务明细
     *
     * @param masId 任务主表ID
     * @return 任务明细
     */
    List<TaskInfoDtlRespVO> selectByMasId(Long masId);

    /**
     * 根据入参查询任务明细
     *
     * @param queryVO 入参
     * @return 任务明细
     */
    List<TaskInfoDtlRespVO> selectByParam(TaskInfoDtlQueryVO queryVO);

    /**
     * 根据主表任务ID更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masId      主表任务ID
     */
    void updateDeleteFlag(Integer deleteFlag, Long masId);

    /**
     * 根据主表任务ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表任务ID
     */
    void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds);

    /**
     * 根据主表任务ID更新完成状态
     *
     * @param completeState 完成状态
     * @param masId         主表任务ID
     */
    void updateCompleteStateByMasId(String completeState, Long masId);

    /**
     * 根据主表任务ID更新完成状态、完成时间
     *
     * @param completeState 完成状态
     * @param completeTime  完成时间
     * @param masId         主表任务ID
     */
    void updateCompleteStateAndTime(String completeState, LocalDateTime completeTime, Long masId);

    /**
     * 根据任务明细ID批量更新完成状态
     *
     * @param completeState 完成状态
     * @param ids           任务明细ID
     */
    void updateCompleteStateByIdBatch(String completeState, List<Long> ids);

    /**
     * 根据任务明细ID开始执行前置校验
     *
     * @param id 任务明细ID
     * @return 任务返给执行的出参
     */
    TaskExecuteRespVO taskDtlExecuteCheck(Long id);

    /**
     * 根据任务明细ID批量关闭前置校验
     *
     * @param ids 任务明细ID
     * @return true 校验通过  false 校验未通过
     */
    Boolean closeCheckTaskBatch(List<Long> ids);

    /**
     * 根据任务明细ID批量关闭
     *
     * @param ids 任务ID
     * @return
     */
    void closeTaskBatch(List<Long> ids);

    /**
     * 任务明细分页查询
     *
     * @param pageParam 入参
     * @return 任务明细信息集合
     */
    PagingVO<TaskInfoDtlRespVO> page(TaskInfoDtlQueryVO pageParam);

    /**
     * 根据任务明细ID批量分配执行人
     *
     * @param saveVO 任务明细入参
     * @return 任务明细ID集合
     */
    List<Long> updateExecuteUserBatch(TaskInfoDtlSaveVO saveVO);


    /****************执行触发开始********************/
    //方法1. 开始执行时，更新任务状态为进行中，任务明细未完全执行完成时‘进行中’——任务明细完全执行完毕后‘已完成’
    //方法2. 执行完毕时，更新任务状态已完成，如果明细全部执行完成，更新主表状态和完成时间
    //场景1. 针对巡店类型的任务完成根据业务员在app上提交执行记录后审核通过自动完成；-调用任务接口更新明细状态已完成
    //场景2. 而针对门店提报等非巡店任务的完成，由业务员完成后手动点击【完成】按钮，标记任务完成。
    /****************执行触发结束********************/
}
