package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.taskinfo.TaskInfoAppQueryVO;
import com.elitesland.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.sale.api.vo.resp.taskinfo.TaskExecuteRespVO;
import com.elitesland.sale.api.vo.resp.taskinfo.TaskInfoAppRespVO;
import com.elitesland.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.sale.api.vo.save.TaskExecutionRecordSaveVO;
import com.elitesland.sale.api.vo.save.TaskInfoDtlSaveVO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
public interface TaskInfoDtlService {

    /**
     * 任务明细保存
     *
     * @param saveVOList 入参
     * @return 任务明细ID
     */
    List<Long> saveTaskInfoDtl(List<TaskInfoDtlSaveVO> saveVOList);

    /**
     * 根据任务主表ID删除任务明细
     *
     * @param masId 任务主表ID
     * @return
     */
    void deleteByMasId(Long masId);

    /**
     * 根据任务主表ID查询任务明细
     *
     * @param masId 任务主表ID
     * @return 任务明细
     */
    List<TaskInfoDtlRespVO> selectByMasId(Long masId);

    /**
     * 根据任务明细ID查询任务明细数据
     *
     * @param id 任务明细ID
     * @return 任务明细数据
     */
    TaskInfoDtlRespVO findById(Long id);

    /**
     * 根据入参查询任务明细
     *
     * @param queryVO 入参
     * @return 任务明细
     */
    List<TaskInfoDtlRespVO> selectByParam(TaskInfoDtlQueryVO queryVO);

    /**
     * 根据主表任务ID更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masId      主表任务ID
     */
    void updateDeleteFlag(Integer deleteFlag, Long masId);

    /**
     * 根据主表任务ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表任务ID
     */
    void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds);

    /**
     * 根据主表任务ID更新完成状态
     *
     * @param completeState 完成状态
     * @param masId         主表任务ID
     */
    void updateCompleteStateByMasId(String completeState, Long masId);

    /**
     * 根据主表任务ID更新完成状态、完成时间
     *
     * @param completeState 完成状态
     * @param completeTime  完成时间
     * @param masId         主表任务ID
     */
    void updateCompleteStateAndTimeByMasId(String completeState, LocalDateTime completeTime, Long masId);

    /**
     * 根据任务明细ID批量更新完成状态
     *
     * @param completeState 完成状态
     * @param ids           任务明细ID
     */
    void updateCompleteStateByIdBatch(String completeState, List<Long> ids);

    /**
     * 根据任务明细ID批量更新是否逾期
     *
     * @param delayFlag 是否逾期
     * @param ids       任务明细ID
     */
    void updateDelayFlagByIdBatch(String delayFlag, List<Long> ids);

    /**
     * 根据任务明细ID开始执行前置校验
     *
     * @param id 任务明细ID
     * @return 任务返给执行的出参
     */
    TaskExecuteRespVO taskDtlExecuteCheck(Long id);

    /**
     * 根据任务明细ID批量关闭前置校验
     *
     * @param ids 任务明细ID
     * @return true 校验通过  false 校验未通过
     */
    Boolean closeCheckTaskBatch(List<Long> ids);

    /**
     * 根据任务明细ID批量关闭
     *
     * @param ids 任务ID
     * @return
     */
    void closeTaskBatch(List<Long> ids);

    /**
     * 任务明细分页查询
     *
     * @param pageParam 入参
     * @return 任务明细信息集合
     */
    PagingVO<TaskInfoDtlRespVO> page(TaskInfoDtlQueryVO pageParam);

    /**
     * 根据任务明细ID批量分配执行人
     *
     * @param saveVO 任务明细入参
     * @return 任务明细ID集合
     */
    List<Long> updateExecuteUserBatch(TaskInfoDtlSaveVO saveVO);

    /****************APP端开始********************/
    /**
     * APP端我的任务-任务明细分页查询
     *
     * @param queryVO 入参
     * @return 任务明细信息集合
     */
    PagingVO<TaskInfoAppRespVO> appDtlPage(TaskInfoAppQueryVO queryVO);

    /****************APP端结束********************/
    /****************执行触发开始********************/

    /**
     * 执行记录保存、提交、审核拒绝、审核通过、关闭时：
     * 根据任务明细ID
     * 更新明细(状态、完成时间、执行记录信息)
     * 更新主表(状态、完成时间、任务进度)
     * <p>
     * 后面执行记录第一次保存/提交后存记录编码
     * 当执行记录提交时，相应的将执行的任务明细完成状态更新为‘待审核’，同时将主表任务状态由‘待执行’更新为‘进行中’
     * <p>
     * 当执行记录审核通过时，更新任务明细完成状态为‘已完成’，同时判断任务明细完成状态是否全部为‘已完成’，
     * 如果是，将任务主表状态更新为‘已完成’，如果不是保持主表任务状态不变；
     * 当任务明细执行状态均为已完成和已关闭时，任务主表状态为已完成；
     *
     * <p>
     * 当有一个甚至全部的任务明细执行状态为待审核、审核拒绝状态时，任务主表状态更新为进行中；
     * <p>
     * 当任务执行关闭操作时，相应的状态也要更新为关闭
     * <p>
     * 当任务明细执行记录审批通过后更新任务完成状态和完成时间；
     * 当任务最后一个明细执行记录审批通过时，不仅更新任务完成状态和完成时间，同时更新任务主表的完成时间
     * 当任务明细全部完成式，主表记录最后完成的一条明细的完成时间，主表记录所有任务明细最终的完成时间
     * 明细记录明细完成状态时的时间
     * <p>
     * 明细记录此条明细的完成时间；
     * 巡店任务类型：当执行记录提交后更新时间；
     * 门店提报类型：标记完成时更新时间
     * <p>
     * 计算更新任务进度，默认为0%，统计任务明细：已完成/总数量算百分比；小数点后4位
     *
     * @param saveVO 任务执行记录更新任务对象入参
     * @return
     */
    void executionRecordCallback(TaskExecutionRecordSaveVO saveVO);

    /****************执行触发结束********************/

}
