package com.elitesland.sale.api.vo.param.taskinfo;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;

import javax.persistence.Column;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 业务员任务管理-任务明细表
 */
@Data
@ApiModel(description = "任务明细表")
public class TaskInfoDtlQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 49283147759775261L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID")
    private List<Long> ids;

    @ApiModelProperty("关联id")
    private Long masId;
    @ApiModelProperty("关联ID")
    private List<Long> masIds;

    @ApiModelProperty("行号")
    private Integer lineNo;

    @ApiModelProperty("业务类型")
    private String businessType;
    @ApiModelProperty("业务类型集合")
    private List<String> businessTypes;

    @ApiModelProperty("业务编码")
    private String businessCode;
    @ApiModelProperty("业务编码集合")
    private List<String> businessCodes;

    @ApiModelProperty("业务id")
    private Long businessId;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("经销商id")
    private Long dealerId;

    @ApiModelProperty("经销商编码")
    private String dealerCode;
    @ApiModelProperty("经销商编码集合")
    private List<String> dealerCodes;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("营业时间")
    private String businessTime;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区")
    private String district;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;
    @ApiModelProperty("执行人code集合")
    private List<String> executUserCodes;

    //@ApiModelProperty("完成时间")
    //private LocalDateTime completeTime;
    @ApiModelProperty("完成时间起始")
    private LocalDateTime completeTimeS;

    @ApiModelProperty("完成时间截至")
    private LocalDateTime completeTimeE;

    @ApiModelProperty("完成状态")
    private String completeState;
    @ApiModelProperty("完成状态集合")
    private List<String> completeStates;
    @ApiModelProperty("非某种完成状态")
    private String noCompleteState;

    @ApiModelProperty("是否逾期")
    private String delayFlag;

    @ApiModelProperty("执行记录")
    private String executRecordName;

    @ApiModelProperty("执行记录id")
    private Long executRecordId;

    @ApiModelProperty("执行记录code")
    private String executRecordCode;

}
