package com.elitesland.sale.api.vo.resp.taskinfo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/13
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "任务返给执行的出参")
public class TaskExecuteRespVO implements Serializable {
    private static final long serialVersionUID = 3033976592079178602L;

    @ApiModelProperty("任务ID")
    private Long taskId;

    @ApiModelProperty("任务编码")
    private String taskCode;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("任务类型")
    private String taskType;
    @ApiModelProperty("任务类型")
    private String taskTypeName;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("发布人")
    private String publishUser;

    @ApiModelProperty("发布人id")
    private Long publishUserId;

    @ApiModelProperty("发布人code")
    private String publishUserCode;

    @ApiModelProperty("执行模板")
    private String executTemplate;

    @ApiModelProperty("执行模板id")
    private Long executTemplateId;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;

    @ApiModelProperty("执行模板名称")
    private String executTemplateName;

    @ApiModelProperty("强制签到")
    private String forceSignFlag;

    @ApiModelProperty("签到范围")
    private BigDecimal signInRange;

    @ApiModelProperty("签退范围")
    private BigDecimal signOutRange;


    /*******************任务明细*****************/

    @ApiModelProperty("任务明细ID")
    private Long taskDtlId;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("业务编码")
    private String businessCode;
    @ApiModelProperty("业务编码集合")
    private List<String> businessCodes;

    @ApiModelProperty("业务名称")
    private String businessName;

    /*******************任务明细*****************/

}
