package com.elitesland.sale.api.vo.param.taskinfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-11
 * @desc : 执行记录模板
 */
@Data
@ApiModel(description = "执行记录模板")
public class ExectRecordTempQueryVO extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "唯一id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("模板编码")
    private String tempCode;

    @ApiModelProperty("模板名称")
    private String tempName;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("任务类型")
    private String taskType;

    @ApiModelProperty("模板描述")
    private String tempDesc;

    @ApiModelProperty("模板描述")
    private List<String> taskTypeList;

}