package com.elitesland.sale.api.service;

import com.elitesland.sale.api.vo.param.pri.RmiDoDParam;
import com.elitesland.sale.api.vo.param.sal.SalSoaPageParam;
import com.elitesland.sale.api.vo.resp.sal.RmiDoDVO;
import com.elitesland.sale.api.vo.resp.sal.SalSoaRespVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

/**
 * @auther JinXK
 * @date 2021/7/7 15:37
 */
public interface SalSoaService {
    /**
     * 对账单分页查询
     */
    PagingVO<SalSoaRespVO> query(SalSoaPageParam pagingParam);

    /**
     * 对账单详情查询
     */
    SalSoaRespVO getById(Long id);

    /**
     * 对账单保存
     */
    ApiResult<Object> save(SalSoaRespVO param);

    /**
     * 对账单确认
     */
    ApiResult<Object> affirm(Long id);

    /**
     * 发货单明细查询
     */
    PagingVO<RmiDoDVO> selectDo(RmiDoDParam param);

    /**
     * 对账单作废
     */
    ApiResult<Object> obsolete(Long id);
}
