package com.elitesland.sale.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @auther JinXK
 * @date 2021/8/17 13:18
 */
@Data
public class SalReceiptDetailStatementDTO implements Serializable {

    @ApiModelProperty("收款单明细id")
    Long receiptDId;

    @ApiModelProperty("销售单号")
    String soNo;

    @ApiModelProperty("销售单行号")
    BigDecimal soLineNo;

    @ApiModelProperty("商品品类")
    String itemClass;

    @ApiModelProperty("商品品类名称")
    String itemClassName;

    @ApiModelProperty("财务分类")
    String financeClass;

    @ApiModelProperty("财务分类名称")
    String financeClassName;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("商品id")
    Long itemId;

    @ApiModelProperty("商品编码")
    String itemCode;

    @ApiModelProperty("商品名称")
    String itemName;

    @ApiModelProperty("税率")
    BigDecimal taxRate;

    @ApiModelProperty("应收款金额")
    BigDecimal totalAmount;

    @ApiModelProperty("收款金额")
    BigDecimal amt;

    @ApiModelProperty("收款税额")
    BigDecimal tax;

    @ApiModelProperty("是否计税")
    String taxFlag;

    @ApiModelProperty("业务类型")
    String businessType;

    @ApiModelProperty("备注")
    String remark;

    @ApiModelProperty("购物卡金额")
    BigDecimal shoppingCardAmt;

    @ApiModelProperty("提货券金额")
    BigDecimal billCouponAmt;

    @ApiModelProperty("使用积分金额")
    BigDecimal scoreAmount;

    @ApiModelProperty("抵扣券金额")
    BigDecimal couponAmount;
}
