package com.elitesland.sale.api.vo.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/5/31 18:55
 */
@Data
@ApiModel(description = "客户地址导入数据")
public class CrmAddrImplSaveVO implements Serializable {

    private static final long serialVersionUID = 5269920145233459111L;
    @ApiModelProperty(value = "客户编码", required = true)
    @NotBlank(message = "客户编码不得为空")
    private String custCode;

    @ApiModelProperty(value = "客户名称", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private String custName;

    @ApiModelProperty(value = "地址类型", required = true)
    @NotBlank(message = "地址类型不得为空")
    private String addressType;

    @ApiModelProperty(value = "是否为默认地址", required = true)
    @NotBlank(message = "默认地址不得为空")
    private String defaultFlag;

    @ApiModelProperty(value = "地址名称", required = true)
    @NotBlank(message = "地址名称不得为空")
    private String addressName;

    @ApiModelProperty(value = "国家", required = true)
    @NotBlank(message = "国家不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private String country;

    @ApiModelProperty(value = "省", required = true)
    @NotBlank(message = "省不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private String province;

    @ApiModelProperty(value = "市", required = true)
    @NotBlank(message = "市不得为空")
    private String city;

    @ApiModelProperty(value = "县/区", required = true)
    @NotBlank(message = "县/区不得为空")
    private String county;

    @ApiModelProperty(value = "乡镇/街道", required = true)
    @NotBlank(message = "乡镇/街道不得为空")
    private String street;

    @ApiModelProperty(value = "详细地址", required = true)
    @NotBlank(message = "详细地址不得为空")
    private String detailAddr;

    @ApiModelProperty(value = "联系人", required = true)
    @NotBlank(message = "联系人不得为空")
    private String contPerson;

    @ApiModelProperty(value = "联系人电话", required = true)
    @NotBlank(message = "联系人电话不得为空")
    private String tel;

    @ApiModelProperty(value = "联系人手机", required = true)
    @NotBlank(message = "联系人手机不得为空")
    private String mobile;

    @ApiModelProperty(value = "传真", required = true)
    @NotBlank(message = "联系人传真不得为空")
    private String fax;

    @ApiModelProperty(value = "邮箱", required = true)
    @NotBlank(message = "联系人邮箱不得为空")
    private String email;
}
