//package com.elitesland.sale.api.service;
//
//import com.alibaba.fastjson.JSONObject;
//import com.elitesland.sale.api.vo.param.pro.SalContractApprParam;
//import com.elitesland.sale.api.vo.param.pro.SalContractPagingParam;
//import com.elitesland.sale.api.vo.param.pro.SalContractQueryParam;
//import com.elitesland.sale.api.vo.param.pro.SalContractSaveParam;
//import com.elitesland.sale.api.vo.resp.pro.SalContractDetailRespVO;
//import com.elitesland.sale.api.vo.resp.pro.SalContractExportVO;
//import com.elitesland.sale.api.vo.resp.pro.SalContractPageRespVO;
//import com.elitesland.sale.api.vo.resp.pro.SalContractSimpleRespVO;
//import com.elitesland.sale.api.vo.resp.sal.SalCommissionRuleVO;
//import com.elitesland.sale.api.vo.save.SalContractImportSaveVO;
//import com.elitesland.sale.api.vo.save.SalContractItemImportSaveVO;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//
//import java.util.List;
//
///**
// * @author Eric.li (Li Jia Zhe)
// * @date 2021/6/8 9:09 上午
// */
//public interface SalContractService {
//
//    /**
//     * 根据查询条件分页查询项目合同信息列表
//     * @param pageParam 查询条件
//     * @return
//     */
//    PagingVO<SalContractPageRespVO> query(SalContractPagingParam pageParam);
//
//    /**
//     * 根据查询条件查询销售合同集合，返回简单信息
//     * @return
//     */
//    List<SalContractSimpleRespVO> queryByParam(SalContractQueryParam param);
//
//    /**
//     * 保存或提交销售合同信息
//     * @param param 参数
//     * @return
//     */
//    JSONObject saveOrSubmit(SalContractSaveParam param, String operate);
//
//    /**
//     * 根据合同ID获取合同详情
//     * @param id 合同ID
//     * @return
//     */
//    SalContractDetailRespVO queryOneDetail(Long id);
//
//    /**
//     * 根据操作类型修改销售合同状态
//     * @param targetOperation 操作，包括：关闭合同、提交合同、审批合同
//     * @param id 销售合同ID
//     * @return
//     */
//    void changeStatusForOperation(String targetOperation, Long id);
//
//    /**
//     * 审批合同
//     * @param apprParam 请求参数
//     * @return
//     */
//    void apprContract(SalContractApprParam apprParam);
//
//    /**
//     * 逻辑删除售合同状态
//     * @param id 销售合同ID
//     * @return
//     */
//    void deleteContract(Long id);
//
//    /**
//     * 复制合同
//     * @param id 要复制的合同ID
//     */
//    void copyContract(Long id);
//
//    /**
//     * 根据项目名称精准查询合同
//     * @param projNames
//     * @return
//     */
//    List<SalContractSimpleRespVO> queryByProjName(List<String> projNames);
//
//    /**
//     * 合同页面详细商品信息导入
//     * @param parseData
//     * @return
//     */
//    ApiResult<List<SalContractItemImportSaveVO>> contractItemImportData(List<SalContractItemImportSaveVO> parseData,Long ouId,String currCode);
//
//
//    /**
//     * 合同转销售单
//     *
//     * @param id 合同id
//     * @return 合同id
//     */
//    Long contractToOrder(Long id);
//
//    /**
//     * 合同页面详细商品信息导入
//     * @param parseData
//     * @return
//     */
//    ApiResult<Object> contractImportData(List<SalContractImportSaveVO> parseData);
//
//
//    /**
//     * 导出查询
//     * @param pageParam 参数
//     * @return 导出类
//     */
//    PagingVO<SalContractExportVO> searchForExport(SalContractPagingParam pageParam);
//
//}
