package com.elitesland.sale.api.vo.param.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 满减促销赠折扣信息主表 保存VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@ApiModel(description = "满减促销赠折扣信息主表 保存VO")
@Data
public class MktDiscountGiftSaveVO implements Serializable {

    private static final long serialVersionUID = 6966083469540288423L;

    @ApiModelProperty("主表ID")
    private Long id;

    @ApiModelProperty("满减赠促销编码")
    private String code;

    @ApiModelProperty("满减赠促销名称")
    private String name;

    @ApiModelProperty("促销生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty("促销失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty("客户等级")
    private String customLevel;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty("销售组织ID")
    private Long buId;

    @ApiModelProperty("组织编码")
    private String buCode;

    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("促销条件:0 件数 1 金额")
    private String type;

    @ApiModelProperty("促销状态")
    private String status;

    @ApiModelProperty("买赠促销明细集合")
    private List<MktDiscountGiftDSaveVO> details;

    @ApiModelProperty(value = "买赠赠品明细集合")
    private List<MktGiftSaveVO> giftDetails;
}
