package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.vo.param.shop.BipCouponCustCurrentParam;
import com.elitesland.sale.api.vo.param.shop.BipCouponQueryParam;
import com.elitesland.sale.api.vo.resp.shop.BipCouponCustVO;
import com.elitesland.sale.api.vo.resp.shop.BipCouponIndexVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * <p>
 * 优惠卷领用记录
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:07:11
 */
public interface BipCouponCustService {

    void deleteCouponCust(Long id);

    List<BipCouponCustVO> currentUserCouponCust(BipCouponCustCurrentParam param);

    void paySuccessUpdateCouponStatus(Long id,String status);


    /**
     * 修改优惠券使用状态未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     * @param id status
     */
    void modifyCouponCustUseStatus(Long id,String status);

    /**
     * 修改优惠券使用状态未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     * @param id status
     */
    void modifyOrderCouponCustUseStatus(Long couponId,String status);

    BipCouponIndexVO indexPageShow();

    ApiResult<Object> receiveCoupon(List<Long> ids);

    PagingVO<BipCouponCustVO> pageSearch(BipCouponQueryParam param);

    List<BipCouponCustVO> searchCouponCust(String useStatus,Long userId);

    void newUserReceiveCoupon();
}
