package com.elitesland.sale.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 返回参数 - 对外销售价查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 2:04 下午
 */
@Data
@ApiModel(value = "PriSalePriceRespDTO", description = "对外销售价查询返回参数")
public class PriCrossPriceDTO implements Serializable {

    private static final long serialVersionUID = 7419075949189142584L;

    /**
     * 公司ID
     */
    private Long ouId;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 区域
     */
    private String region;

    /**
     * 货币码
     */
    private String currCode;

    /**
     * 价格结果
     */
    private List<PriCrossPriceSimpleDTO> priceList;

}
